﻿namespace Microsoft.Samples.PlanMyNight.AddIns.Share.Tests.Models
{
    using Microsoft.Samples.PlanMyNight.AddIns.Share.Models;
    using Microsoft.VisualStudio.TestTools.UnitTesting;

    [TestClass]
    public class TinyUrlServiceFixture
    {
        [TestMethod]
        public void GenerateShortUrl()
        {
            var url = "http://msdn.microsoft.com/";
            var expectedResult = "http://tinyurl.com/2htn";

            var tinyUrl = new TinyUrlService();
            var result = tinyUrl.GeneratedShortUrl(url);

            Assert.IsNotNull(result);
            Assert.AreEqual(expectedResult, result.ToString());
        }

        [TestMethod]
        public void GenerateWrongShortUrlReturnsNull()
        {
            var url = string.Empty;

            var tinyUrl = new TinyUrlService();
            var result = tinyUrl.GeneratedShortUrl(url);

            Assert.IsNull(result);
        }
    }
}
